* predict all manufacturing with manufacturing expectations
sort year_q
gen expballmanl2=expbalmannf[_n-2]
gen interman1=expballmanl2*lvaman_rl2
gen interman2=expballmanl2*lcostperladj_rl2
gen interman3=expballmanl2*year_q
reg lemplman lvaman_rl2 lcostperladj_rl2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expballmanl2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expballmanl2 interman1 interman2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expballmanl2 interman1 interman2 interman3 year_q if year<=2003

* instead calculate cumulative expectations
sort year_q
gen expcummannfl2=expcummannf[_n-2]
gen intermancum1=expcummannfl2*lvaman_rl2
gen intermancum2=expcummannfl2*lcostperladj_rl2
gen intermancum3=expcummannfl2*year_q
reg lemplman lvaman_rl2 lcostperladj_rl2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expcummannfl2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expcummannfl2 intermancum1 intermancum2 year_q if year<=2003
reg lemplman lvaman_rl2 lcostperladj_rl2 expcummannfl2 intermancum1 intermancum2 intermancum3 year_q if year<=2003

* do in differences, with raw expectations
gen dinterman1=expballmanl2*dlvaman_r
gen dinterman2=expballmanl2*dlcostperladj_r
sort year_q

do ~/research/BPEA_recession/statprog/timevar
newey dlemplman dlvaman_r dlcostperladj_r if year<=2003,lag(4)
reg dlemplman dlvaman_r dlcostperladj_r if year<=2003
predict dlemplmanhat1
* predict the level
gen lemplmanhat1=lemplman if year<=2003
replace lemplmanhat1=lemplmanhat1[_n-1]+dlemplmanhat1 if lemplmanhat1==.
.
replace lemplmanhat1=. if year_q<=2002.75

* with interactions - they are insig
reg dlemplman dlvaman_r dlcostperladj_r expballmanl2 dinterman1 dinterman2 if year<=2003

* so focus on without interactions
newey dlemplman dlvaman_r dlcostperladj_r expballmanl2 if year<=2003,lag(4)
reg dlemplman dlvaman_r dlcostperladj_r expballmanl2 if year<=2003
predict dlemplmanhat2
* predict the level
gen lemplmanhat2=lemplman if year<=2003
replace lemplmanhat2=lemplmanhat2[_n-1]+dlemplmanhat2 if lemplmanhat2==.
.
replace lemplmanhat2=. if year_q<=2002.75

* do counterfactual where 
* best predictor of manuf expectations is current overall situation
* same R2 levels or diffs, but coeff on current much higher in diffs
* do regs for <=2003, but only do counterfactual from start of boom
* Q1 2005

sort year_q
gen dexpbalmannf=expbalmannf-expbalmannf[_n-1]
gen dcurrbal=currbal-currbal[_n-1]
reg dexpbalmannf dcurrbal if year<=2003
predict dexpmancounter
*drop dcurrbal dexpbalmannf
gen expmancounter=expbalmannf if year_q<2005.25
replace expmancounter=expmancounter[_n-1]+dexpmancounter if expmancounter==.

* do 2nd set of counterfactuals starting from where were after boom, so
* to say, given where were until then, compare actual/prediction recession
* expectations
gen expmancounter2=expbalmannf if year_q<2007.75
replace expmancounter2=expmancounter2[_n-1]+dexpmancounter if expmancounter2==.

sort year_q
gen expmancounterl2=expmancounter[_n-2]

* redo key reg
reg dlemplman dlvaman_r dlcostperladj_r expballmanl2 if year<=2003

gen dlemplmancounter=_b[_cons]+_b[dlvaman_r]*dlvaman_r+_b[dlcostperladj_r]*dlcostperladj_r+_b[expballmanl2]*expmancounterl2
gen lemplmancounter=lemplman if year<=2003
replace lemplmancounter=lemplmancounter[_n-1]+dlemplmancounter if lemplmancounter==.
replace lemplmancounter=. if year_q<2005.25

label var lemplman "actual manuf L"
label var lemplmanhat1 "predict manuf changes w/o expectations"
label var lemplmanhat2 "predict manuf changes w expectations"
label var lemplmancounter "counterfactual manuf L changes"
*gr7 lemplman lemplmanhat1 lemplmanhat2 lemplmancounter year_q,c(llll) s(....) xline(2005)

* now check differences in these
gen dlemplmanb=.
gen dlemplmanhat1b=.
gen dlemplmanhat2b=.
gen dlemplmancounterb=.
* boom Q3 2005- Q3 2008 (if looking at va varibles, lag 2 quarters)
replace dlemplmancounterb=lemplmancounter-lemplmancounter[_n-12] if year==2008&quarter==3
replace dlemplmanhat2b=lemplmanhat2-lemplmanhat2[_n-12] if year==2008&quarter==3
replace dlemplmanb=lemplman-lemplman[_n-12] if year==2008&quarter==3
replace dlemplmanhat1b=lemplmanhat1-lemplmanhat1[_n-12] if year==2008&quarter==3

* bust Q3 2008 - Q3 2009
replace dlemplmancounterb=lemplmancounter-lemplmancounter[_n-4] if year==2009&quarter==3
replace dlemplmanhat2b=lemplmanhat2-lemplmanhat2[_n-4] if year==2009&quarter==3
replace dlemplmanb=lemplman-lemplman[_n-4] if year==2009&quarter==3
replace dlemplmanhat1b=lemplmanhat1-lemplmanhat1[_n-4] if year==2009&quarter==3

* recovery Q3 2009 - Q3 2010
replace dlemplmancounterb=lemplmancounter-lemplmancounter[_n-4] if year==2010&quarter==3
replace dlemplmanhat2b=lemplmanhat2-lemplmanhat2[_n-4] if year==2010&quarter==3
replace dlemplmanb=lemplman-lemplman[_n-4] if year==2010&quarter==3
replace dlemplmanhat1b=lemplmanhat1-lemplmanhat1[_n-4] if year==2010&quarter==3

label var dlemplmanb "actual manuf L, relevant changes"
label var dlemplmanhat1b "predict manuf changes w/o expectations"
label var dlemplmanhat2b "predict manuf changes w expectations"
label var dlemplmancounterb "counterfactual manuf L changes"

* how much missing employment growth in boom is due to expectations?
gen diffmanb=dlemplmancounterb-dlemplmanhat2b

list dlemplmanb dlemplmanhat1b dlemplmanhat2b dlemplmancounterb diffmanb if year>=2007

* redo using exact boom and bust dates for employment in manufacturing, namely
* boom Q1 2006-Q3 2008
* bust Q3 2008-Q1 2010
* recovery, to extent there is one Q1 2010-Q3 2010
* now check differences in these
gen dlemplmanc=.
gen dlemplmanhat1c=.
gen dlemplmanhat2c=.
gen dlemplmancounterc=.
* boom Q1 2006- Q3 2008
replace dlemplmancounterc=lemplmancounter-lemplmancounter[_n-10] if year==2008&quarter==3
replace dlemplmanhat2c=lemplmanhat2-lemplmanhat2[_n-10] if year==2008&quarter==3
replace dlemplmanc=lemplman-lemplman[_n-10] if year==2008&quarter==3
replace dlemplmanhat1c=lemplmanhat1-lemplmanhat1[_n-10] if year==2008&quarter==3

* bust Q3 2008 - Q1 2010
replace dlemplmancounterc=lemplmancounter-lemplmancounter[_n-6] if year==2010&quarter==1
replace dlemplmanhat2c=lemplmanhat2-lemplmanhat2[_n-6] if year==2010&quarter==1
replace dlemplmanc=lemplman-lemplman[_n-6] if year==2010&quarter==1
replace dlemplmanhat1c=lemplmanhat1-lemplmanhat1[_n-6] if year==2010&quarter==1

* recovery Q1 2010 - Q3 2010
replace dlemplmancounterc=lemplmancounter-lemplmancounter[_n-2] if year==2010&quarter==3
replace dlemplmanhat2c=lemplmanhat2-lemplmanhat2[_n-2] if year==2010&quarter==3
replace dlemplmanc=lemplman-lemplman[_n-2] if year==2010&quarter==3
replace dlemplmanhat1c=lemplmanhat1-lemplmanhat1[_n-2] if year==2010&quarter==3

label var dlemplmanc "actual manuf L, relevant changes"
label var dlemplmanhat1c "predict manuf changes w/o expectations"
label var dlemplmanhat2c "predict manuf changes w expectations"
label var dlemplmancounterc "counterfactual manuf L changes"

* how much missing employment growth in boom is due to expectations?
gen diffmanc=dlemplmancounterc-dlemplmanhat2c

list dlemplmanc dlemplmanhat1c dlemplmanhat2c dlemplmancounterc diffmanc if year>=2007

*drop lvax_r-diffmanc





